% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{loadd}
\alias{loadd}
\title{Function \code{loadd}}
\usage{
loadd(..., list = character(0), imported_only = FALSE, path = getwd(),
  search = TRUE, cache = drake::get_cache(path = path, search = search,
  verbose = verbose), envir = parent.frame(), jobs = 1, verbose = TRUE)
}
\arguments{
\item{...}{targets to load from the cache, as names (unquoted)
or character strings (quoted). Similar to \code{...} in
\code{\link{remove}(...)}.}

\item{list}{character vector naming targets to be loaded from the
cache. Similar to the \code{list} argument of \code{\link{remove}()}.}

\item{imported_only}{logical, whether only imported objects
should be loaded.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{envir}{environment to load objects into. Defaults to the
calling environment (current workspace).}

\item{jobs}{number of parallel jobs for loading objects. On
non-Windows systems, the loading process for multiple objects
can be lightly parallelized via \code{parallel::mclapply()}.
just set jobs to be an integer greater than 1. On Windows,
\code{jobs} is automatically demoted to 1.}

\item{verbose}{whether to print console messages}
}
\description{
Load object(s) from the drake cache into the
current workspace (or \code{envir} if given). Defaults
to loading the whole cache if arguments \code{...}
and \code{list} are not set
(or all the imported objects if in addition
imported_only is \code{TRUE}).
}
\examples{
\dontrun{
load_basic_example()
make(my_plan)
loadd(reg1) # now check ls()
reg1
loadd(small)
small
loadd(list = c("small", "large"), jobs = 2)
loadd(imported_only = TRUE) # load all imported objects and functions
loadd() # load everything, including built targets
}
}
\seealso{
\code{\link{cached}}, \code{\link{built}},
\code{\link{imported}}, \code{\link{workplan}}, \code{\link{make}},
}
