% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.r
\name{filter}
\alias{filter}
\title{Return rows with matching conditions}
\usage{
filter(.data, ...)
}
\arguments{
\item{.data}{A tbl. All main verbs are S3 generics and provide methods
for \code{\link[=tbl_df]{tbl_df()}}, \code{\link[dtplyr:tbl_dt]{dtplyr::tbl_dt()}} and \code{\link[dbplyr:tbl_dbi]{dbplyr::tbl_dbi()}}.}

\item{...}{Logical predicates defined in terms of the variables in \code{.data}.
Multiple conditions are combined with \code{&}. Only rows where the
conditon evalutes to \code{TRUE} are kept.

These arguments are automatically \link[rlang:quo]{quoted} and
\link[rlang:eval_tidy]{evaluated} in the context of the data
frame. They support \link[rlang:quasiquotation]{unquoting} and
splicing. See \code{vignette("programming")} for an introduction to
these concepts.}
}
\value{
An object of the same class as \code{.data}.
}
\description{
Use \code{filter()} find rows/cases where conditions are true. Unlike
base subsetting, rows where the condition evaluates to \code{NA} are dropped.
}
\details{
Note that dplyr is not yet smart enough to optimise filtering optimisation
on grouped datasets that don't need grouped calculations. For this reason,
filtering is often considerably faster on \code{\link[=ungroup]{ungroup()}}ed data.
}
\section{Useful filter functions}{

\itemize{
\item \code{\link{==}}, \code{\link{>}}, \code{\link{>=}} etc
\item \code{\link{&}}, \code{\link{|}}, \code{\link{!}}, \code{\link[=xor]{xor()}}
\item \code{\link[=is.na]{is.na()}}
\item \code{\link[=between]{between()}}, \code{\link[=near]{near()}}
}
}

\section{Tidy data}{

When applied to a data frame, row names are silently dropped. To preserve,
convert to an explicit variable with \code{\link[tibble:rownames_to_column]{tibble::rownames_to_column()}}.
}

\section{Scoped filtering}{

The three \link{scoped} variants (\code{\link[=filter_all]{filter_all()}}, \code{\link[=filter_if]{filter_if()}} and
\code{\link[=filter_at]{filter_at()}}) make it easy to apply a filtering condition to a
selection of variables.
}

\examples{
filter(starwars, species == "Human")
filter(starwars, mass > 1000)

# Multiple criteria
filter(starwars, hair_color == "none" & eye_color == "black")
filter(starwars, hair_color == "none" | eye_color == "black")

# Multiple arguments are equivalent to and
filter(starwars, hair_color == "none", eye_color == "black")
}
\seealso{
\code{\link[=filter_all]{filter_all()}}, \code{\link[=filter_if]{filter_if()}} and \code{\link[=filter_at]{filter_at()}}.

Other single table verbs: \code{\link{arrange}},
  \code{\link{mutate}}, \code{\link{select}},
  \code{\link{slice}}, \code{\link{summarise}}
}
