% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multinomial.R
\name{pdf.Multinomial}
\alias{pdf.Multinomial}
\alias{log_pdf.Multinomial}
\title{Evaluate the probability mass function of a Multinomial distribution}
\usage{
\method{pdf}{Multinomial}(d, x, ...)

\method{log_pdf}{Multinomial}(d, x, ...)
}
\arguments{
\item{d}{A \code{Multinomial} object created by a call to \code{\link[=Multinomial]{Multinomial()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Please see the documentation of \code{\link[=Multinomial]{Multinomial()}} for some properties
of the Multinomial distribution, as well as extensive examples
showing to how calculate p-values and confidence intervals.
}
\examples{

set.seed(27)

X <- Multinomial(size = 5, p = c(0.3, 0.4, 0.2, 0.1))
X

random(X, 10)

# pdf(X, 2)
# log_pdf(X, 2)
}
\seealso{
Other Multinomial distribution: 
\code{\link{random.Multinomial}()}
}
\concept{Multinomial distribution}
