% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffeqr.R
\name{dde.solve}
\alias{dde.solve}
\title{Solve Delay Differential Equations (DDE)}
\usage{
dde.solve(f, u0, h, tspan, p = NULL, alg = "nothing", reltol = 0.001,
  abstol = 1e-06, saveat = NULL, constant_lags = NULL)
}
\arguments{
\item{f}{the implicit ODE function.}

\item{u0}{the initial condition. Can be a number or (arbitrary dimension) array.}

\item{h}{is the history function (p,t) which gives values of the solution before the initial time point.}

\item{tspan}{the timespan to solve over. Should be a list of two values: (initial time, end time).}

\item{p}{the parameters. Defaults to no parameters. Can be a number or an array.}

\item{alg}{the algorithm used to solve the differential equation. Defaults to an adaptive choice.
Algorithm choices are done through a string which matches the DifferentialEquations.jl form.}

\item{reltol}{the relative tolerance of the ODE solver. Defaults to 1e-3.}

\item{abstol}{the absolute tolerance of the ODE solver. Defaults to 1e-6}

\item{saveat}{the time points to save values at. Should be an array of times. Defaults to automatic.}

\item{constant_lags}{a vector of floats for the constant-time lags. Defaults to NULL.}
}
\value{
sol. Has the sol$t for the time points and sol$u for the values.
}
\description{
Solves a DDE with f(u,p,t)=0 for u(0)=u0 over the tspan
}
\examples{

\donttest{ ## diffeq_setup() is time-consuming and requires Julia+DifferentialEquations.jl

diffeqr::diffeq_setup()

f = JuliaCall::julia_eval("function f(du, u, h, p, t)
  du[1] = 1.1/(1 + sqrt(10)*(h(p, t-20)[1])^(5/4)) - 10*u[1]/(1 + 40*u[2])
  du[2] = 100*u[1]/(1 + 40*u[2]) - 2.43*u[2]
end")
u0 = c(1.05767027/3, 1.030713491/3)
h <- function (p,t){
  c(1.05767027/3, 1.030713491/3)
}
tspan = list(0.0, 100.0)
constant_lags = c(20.0)
sol = diffeqr::dde.solve('f',u0,h,tspan,constant_lags=constant_lags)
udf = as.data.frame(sol$u)
#plotly::plot_ly(udf, x = sol$t, y = ~V1, type = 'scatter', mode = 'lines') \%>\%
#plotly::add_trace(y = ~V2)
}

}
