% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pHetErrOnStateCount.r
\name{pHetErrOnStateCount}
\alias{pHetErrOnStateCount}
\title{Hybrid index, heterozygosity, error rate}
\usage{
pHetErrOnStateCount(sCount)
}
\arguments{
\item{sCount}{a numeric vector of length 4 with allele counts for missing data,
homozygots for allele 1, heterozygots, and homozygots for allele 2.}
}
\value{
Returns a named numeric vector with three values: p - hybrid index,
Het - heterozigosity,
Err - error rate.
}
\description{
Using genotype allele counts, calculates
the hybrid index,
heterozygosity and error rate in a single individual.
}
\details{
Allele counts are genomic state counts multiplied by ploidy. As different
compartments might have different ploidies (e.g. autosomal markers, sex chromosomes,
mitochondrial markers), allele counts should be calculated per compartment and then
summarised to obtain the correct genomic allele counts.
When all individuals in each compartmenst have the same ploidy, state counts do
not need to be corrected.
}
\examples{
pHetErrOnStateCount(sCount = c(2, 4, 2, 6))
#         p       Het       Err
# 0.5833333 0.1666667 0.1428571
}
