% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/space_filling.R
\name{grid_max_entropy}
\alias{grid_max_entropy}
\alias{grid_max_entropy.parameters}
\alias{grid_max_entropy.list}
\alias{grid_max_entropy.param}
\alias{grid_latin_hypercube}
\alias{grid_latin_hypercube.parameters}
\alias{grid_latin_hypercube.list}
\alias{grid_latin_hypercube.param}
\title{Max-entropy and latin hypercube grids}
\usage{
grid_max_entropy(
  x,
  ...,
  size = 3,
  original = TRUE,
  variogram_range = 0.5,
  iter = 1000
)

\method{grid_max_entropy}{parameters}(
  x,
  ...,
  size = 3,
  original = TRUE,
  variogram_range = 0.5,
  iter = 1000
)

\method{grid_max_entropy}{list}(
  x,
  ...,
  size = 3,
  original = TRUE,
  variogram_range = 0.5,
  iter = 1000
)

\method{grid_max_entropy}{param}(
  x,
  ...,
  size = 3,
  original = TRUE,
  variogram_range = 0.5,
  iter = 1000
)

grid_latin_hypercube(x, ..., size = 3, original = TRUE)

\method{grid_latin_hypercube}{parameters}(x, ..., size = 3, original = TRUE)

\method{grid_latin_hypercube}{list}(x, ..., size = 3, original = TRUE)

\method{grid_latin_hypercube}{param}(x, ..., size = 3, original = TRUE)
}
\arguments{
\item{x}{A \code{param} object, list, or \code{parameters}.}

\item{...}{One or more \code{param} objects (such as \code{\link[=mtry]{mtry()}} or
\code{\link[=penalty]{penalty()}}). None of the objects can have \code{unknown()} values in
the parameter ranges or values.}

\item{size}{A single integer for the maximum number of parameter value
combinations returned. If duplicate combinations are
generated from this size, the smaller, unique set is returned.}

\item{original}{A logical: should the parameters be in the original units or
in the transformed space (if any)?}

\item{variogram_range}{A numeric value greater than zero. Larger values
reduce the likelihood of empty regions in the parameter space. Only used
for \code{type = "max_entropy"}.}

\item{iter}{An integer for the maximum number of iterations used to find
a good design. Only used for \code{type = "max_entropy"}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

These functions are deprecated because they have been replaced by
\code{\link[=grid_space_filling]{grid_space_filling()}}.
}
\examples{
grid_latin_hypercube(penalty(), mixture(), original = TRUE)

}
\keyword{internal}
