% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{em_converged}
\alias{em_converged}
\title{Convergence Test for EM-Algorithm}
\usage{
em_converged(loglik, previous_loglik, tol = 1e-04, check.increased = FALSE)
}
\arguments{
\item{loglik}{numeric. Current value of the log-likelihood function.}

\item{previous_loglik}{numeric. Value of the log-likelihood function at the previous iteration.}

\item{tol}{numerical. The tolerance of the test. If |LL(t) - LL(t-1)| / avg < tol, where avg = (|LL(t)| + |LL(t-1)|)/2, then algorithm has converged.}

\item{check.increased}{logical. Check if likelihood has increased.}
}
\value{
A logical statement indicating whether EM algorithm has converged. if \code{check.increased = TRUE}, a vector with 2 elements indicating the convergence status and whether the likelihood has decreased.
}
\description{
Convergence Test for EM-Algorithm
}
\examples{
em_converged(1001, 1000)
em_converged(10001, 10000)
em_converged(10001, 10000, check = TRUE)
em_converged(10000, 10001, check = TRUE)
}
