% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_dir.R
\name{model_dir}
\alias{model_dir}
\title{Directional DEA model.}
\usage{
model_dir(datadea,
            dmu_eval = NULL,
            dmu_ref = NULL,
            dir_input = NULL,
            dir_output = NULL,
            d_input = 1,
            d_output = 1,
            rts = c("crs", "vrs", "nirs", "ndrs", "grs"),
            L = 1,
            U = 1,
            maxslack = TRUE,
            weight_slack_i = 1,
            weight_slack_o = 1,
            returnlp = FALSE,
            ...)
}
\arguments{
\item{datadea}{A \code{deadata} object with \code{n} DMUs, \code{m} inputs and \code{s}
outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.
If \code{NULL} (default), all DMUs are considered.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation
reference set.
If \code{NULL} (default), all DMUs are considered.}

\item{dir_input}{A value, vector of length \code{m}, or matrix \code{m} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the input directions.
If \code{dir_input} == input matrix (of DMUS in \code{dmu_eval}) and
\code{dir_output} == 0, it is equivalent to input oriented (\code{beta} = 1 -
\code{efficiency}). If \code{dir_input} is omitted, input matrix (of DMUS in
\code{dmu_eval}) is assigned.}

\item{dir_output}{A value, vector of length \code{s}, or matrix \code{s} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the output directions.
If \code{dir_input} == 0 and \code{dir_output} == output matrix (of DMUS in
\code{dmu_eval}), it is equivalent to output oriented (\code{beta} = \code{efficiency} - 1).
If \code{dir_output} is omitted, output matrix (of DMUS in \code{dmu_eval}) is assigned.}

\item{d_input}{A value, vector of length \code{m}, or matrix \code{m} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the input orientation parameters.
If \code{d_input} == 1 (default) and \code{d_output} == 0, it is equivalent
to input oriented. It is an alternative for \code{dir_input}.}

\item{d_output}{A value, vector of length \code{s}, or matrix \code{s} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the output orientation parameters.
If \code{d_input} == 0 and \code{d_output} == 1 (default), it is equivalent
to output oriented. It is an alternative to \code{dir_output}.}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing), "ndrs" (non-decreasing) or "grs" (generalized).}

\item{L}{Lower bound for the generalized returns to scale (grs).}

\item{U}{Upper bound for the generalized returns to scale (grs).}

\item{maxslack}{Logical. If it is \code{TRUE}, it computes the max slack solution.}

\item{weight_slack_i}{A value, vector of length \code{m}, or matrix \code{m} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the weights of the input slacks
for the max slack solution.}

\item{weight_slack_o}{A value, vector of length \code{s}, or matrix \code{s} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the weights of the output
slacks for the max slack solution.}

\item{returnlp}{Logical. If it is \code{TRUE}, it returns the linear problems
(objective function and constraints) of stage 1.}

\item{...}{Ignored, for compatibility issues.}
}
\value{
A list of class \code{dea} with the results for the evaluated DMUs (\code{DMU} component,
we note that we call "targets" to the "efficient projections"
in the strongly efficient frontier),
 along with any other necessary information to replicate the results, such as
 the name of the model and parameters \code{orientation_param}, \code{rts},
 \code{dmu_eval} and \code{dmu_ref}.
}
\description{
It solves directional, basic DEA models under constant, variable,
non-increasing, non-decreasing or generalized returns to scale. By default,
models are solved in a two-stage process (slacks are maximized).
}
\examples{

data("PFT1981") 
# Selecting DMUs in Program Follow Through (PFT)
PFT <- PFT1981[1:49, ] 
PFT <- make_deadata(PFT, 
                    inputs = 2:6, 
                    outputs = 7:9 )
eval_pft <- model_dir(PFT)
efficiencies(eval_pft)
 
}
\references{
Chambers, R.G.; Chung, Y.; Färe, R. (1996). "Benefit and Distance Functions",
Journal of Economic Theory, 70(2), 407-419. 

Chambers, R.G.; Chung, Y.; Färe, R. (1998). "Profit Directional Distance
Functions and Nerlovian Efficiency", Journal of Optimization Theory and
Applications, 95, 351-354.
}
\seealso{
\code{\link{model_basic}}, \code{\link{model_lgo}}, \code{\link{model_qgo}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
