% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnomalyAssessment.R
\name{ListAnomalyAssessmentRecords}
\alias{ListAnomalyAssessmentRecords}
\title{Retrieve anomaly assessment records.}
\usage{
ListAnomalyAssessmentRecords(
  projectId,
  modelId,
  backtest = NULL,
  source = NULL,
  seriesId = NULL,
  limit = 100,
  offset = 0
)
}
\arguments{
\item{projectId}{character. The ID of the project.}

\item{modelId}{character. The ID of the model.}

\item{backtest}{integer or "holdout". Optional.  The backtest to filter records by.}

\item{source}{"training" or "validation". Optional. The source of the data to filter records by.}

\item{seriesId}{character. Optional. Can be specified for multiseries projects.
The series id to filter records by.}

\item{limit}{integer, greater than zero. Optional. Defaults to 100. At most this many results
are returned. The default may change without notice.}

\item{offset}{integer. Optional. Default is 0. This many results will be skipped.}
}
\value{
A list of objects with anomaly assessment metadata:
\itemize{
\item recordId. character. The ID of the record.
\item projectId. character. The project ID of the record.
\item modelId. character. The model ID of the record.
\item backtest. character. The backtest of the record.
\item source. character. The source of the record.
\item seriesId. character. the series ID of the record.
\item status. character. The status of the insight.
\item statusDetails. character. The explanation of the status.
\item startDate. POSIXct. Timestamp of the first prediction in the subset. Will be NULL if
status is not \code{completed}.
\item endDate. POSIXct. Timestamp of the last prediction in the subset. Will be NULL
if status is not \code{completed}.
\item predictionThreshold. numeric. The threshold, all rows with anomaly scores greater or
equal to it have shap explanations computed. Will be NULL if status is not \code{completed}.
\item previewLocation. character. URL to retrieve predictions preview for the subset.
Will be NULL if status is not \code{completed}.
\item latestExplanationsLocation. character. the URL to retrieve the latest predictions with
the shap explanations. Will be NULL if status is not \code{completed}.
\item deleteLocation. character. the URL to delete anomaly assessment record and
relevant insight data.
}
}
\description{
Retrieve anomaly assessment records.
}
\examples{
\dontrun{
projectId <- "59a5af20c80891534e3c2bde"
modelId <- "59a5af20c80891534e3c2bdd"
records <- ListAnomalyAssessmentRecords(projectId, modelId, backtest=0, seriesId="Baltimore")
}
}
\seealso{
Other Anomaly Assessment functions: 
\code{\link{DeleteAnomalyAssessmentRecord}()},
\code{\link{GetAnomalyAssessmentExplanations}()},
\code{\link{GetAnomalyAssessmentPredictionsPreview}()},
\code{\link{InitializeAnomalyAssessment}()}
}
\concept{Anomaly Assessment functions}
