% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence.R
\name{sequence}
\alias{sequence}
\alias{ScenarioSequence-class}
\title{Sequence of scenarios}
\usage{
sequence(seq, breaks = NULL)
}
\arguments{
\item{seq}{list of \link{scenario} objects}

\item{breaks}{optional vector of \emph{numerics}, scenarios' output times will
be modified so that one scenario ends at the break and the next one begins}
}
\value{
an S4 object of type \linkS4class{ScenarioSequence}
}
\description{
A sequence of scenarios is treated as a single scenario and each scenario
is simulated one after the other. If scenario \code{n} in a sequence was simulated,
scenario \code{n+1} will start off in the model state where \code{n} has ended.
Scenario sequences can be used to e.g. implement changes in model parameters
over time.
}
\details{
\subsection{Requirements}{

All scenarios in a sequence must fulfill the following requirements:
\itemize{
\item All scenarios must have identical state variables
\item The \emph{output times} of all scenarios must represent a continuous time series
without gaps or overlaps
}

Using the \code{breaks} parameter, the function can split up the scenarios'
output times at the given break points. The break points must be within
the interval defined by the superset of all output times in the sequence.
}

\subsection{Limitations}{

Only simulation of sequences are supported, at the moment.
Effects and effect profiles (EPx values) cannot be derived, yet.
}
}
\examples{
# Create a scenario with background mortality only
scen1 <- minnow_it \%>\%
  set_noexposure() \%>\%
  set_times(0:10)
# Modify a scenario parameter, e.g. set background mortality to zero
scen2 <- scen1 \%>\% set_param(c(hb=0))

# Create a sequence of scenarios, scenario #1 will be simulated for the
# time period [0, 4], and #2 for [4, 10]
sq <- sequence(list(scen1, scen2), breaks=c(4))

# Simulate the sequence: the mortality stops after t=4.0, due to scenario #2
# being simulated after t=4.0, which disabled the background mortality
simulate(sq)

}
