% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-ExposureSeries.R
\name{ExposureSeries}
\alias{ExposureSeries}
\alias{ExposureSeries-class}
\title{Exposure time-series}
\usage{
ExposureSeries(series, dates, file, meta, context)
}
\arguments{
\item{series}{\code{data.frame} with two columns containing a time-series}

\item{dates}{\code{vector}, optional original list of time stamps}

\item{file}{\code{character}, optional file name where data originates from}

\item{meta}{\code{list}, optional metadata}

\item{context}{\code{list} optional contextual metadata such as project ids}
}
\value{
an S4 object of type \linkS4class{ExposureSeries}
}
\description{
Creates an object that encapsulates an exposure time-series with its
metadata, such as formatted datetime strings and file name where the
series was loaded from. \code{\link[=no_exposure]{no_exposure()}} is shorthand to create a time-series
of constant zero exposure.
}
\section{Slots}{

\describe{
\item{\code{dates}}{original time points of time-series, e.g. time stamps of the form \verb{2000-01-01 12:00}}

\item{\code{file}}{\code{character}, file name where data originates from, may be empty}

\item{\code{meta}}{\code{list}, contains metadata}

\item{\code{context}}{\code{list}, contains contextual metadata, such as project ids}

\item{\code{series}}{\code{data.frame} containing the actual time-series}
}}

\seealso{
\code{\link[=no_exposure]{no_exposure()}}
}
