% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_bar}
\alias{plot_bar}
\title{Plot Bar}
\usage{
plot_bar(
  dat,
  x,
  y = NULL,
  x_breaks = NULL,
  y_breaks = NULL,
  cut_bin = "equal_width",
  g_x = 10,
  g_y = 5,
  string_bins = FALSE,
  target = NULL,
  value = NULL,
  type = "total_pct",
  reverse = FALSE,
  position = "dodge",
  dodge_width = 0.9,
  pl_theme = plot_theme(legend.position = "top", title_size = 9, legend_size = 7,
    axis_title_size = 8),
  fill_colors = c(love_color(type = "deep"), love_color(type = "light"),
    love_color(type = "shallow"))
)
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{x}{The name of an independent variable.}

\item{y}{The name of target variable. Default is NULL.}

\item{x_breaks}{Breaks points of x.}

\item{y_breaks}{Breaks points of y.}

\item{cut_bin}{'equal_width' or 'equal_depth' to produce the breaks points.}

\item{g_x}{Number of initial breakpoints for equal frequency binning of x.}

\item{g_y}{Number of initial breakpoints for equal frequency binning of y.}

\item{string_bins}{Whether to process bins of classification variables.}

\item{target}{The name of target variable.}

\item{value}{The name of the variable to sum. When this parameter is NULL, the default statistics is to sum frequency.}

\item{type}{Output form of the result of crosstable. 
Provide these forms:"each_pct_x", "each_pct_y","total_sum","total_pct","total_mean","total_median","total_max","total_min","bad_sum","bad_pct".}

\item{reverse}{Logical,whether reverse the plot.}

\item{position}{Postion of bars, 'stack' or 'dodge' is available.}

\item{dodge_width}{Width of width.}

\item{pl_theme}{Theme of the plot}

\item{fill_colors}{Colors of bar.}
}
\description{
You can use the \code{plot_bar} to produce the barplot.
}
\examples{
plot_bar(dat = lendingclub, x = "grade")
plot_bar(dat = lendingclub, x = "grade", y= "dti", 
         g_x = 5,g_y = 3,
		 position = 'dodge', dodge_width = 0.9,
		 type = "each_pct_x",
		 reverse = FALSE,
		 cut_bin = 'equal_depth',
 fill_colors = c(love_color(type = "line"),
  love_color(type = "line")))
}
