% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformation.R
\name{var_group_proc}
\alias{var_group_proc}
\title{Process group numeric variables}
\usage{
var_group_proc(dat, ID = NULL, group = NULL, num_var = NULL)
}
\arguments{
\item{dat}{A data.frame contained only predict variables.}

\item{ID}{The name of ID of observations or key variable of data. Default is NULL.}

\item{group}{The group of behavioral or status variables.}

\item{num_var}{The name of numeric variable to process.}
}
\description{
This function is used for grouped numeric data processing.
}
\examples{
dat = data.frame(id = c(1,1,1,2,2,3,3,3,4,4,4,4,4,5,5,6,7,7,
                            8,8,8,9,9,9,10,10,11,11,11,11,11,11),
                     terms = c('a','b','c','a','c','d','d','a',
                               'b','c','a','c','d','a','c',
                                  'd','a','e','f','b','c','f','b',
                               'c','h','h','i','c','d','g','k','k'),
                     time = c(8,3,1,9,6,1,4,9,1,3,4,8,2,7,1,
                              3,4,1,8,7,2,5,7,8,8,2,1,5,7,2,7,3))

time_series_proc(dat = dat, ID = 'id', group = 'terms',time = 'time')
}
