% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_selection.R
\name{reduce_high_cor_filter}
\alias{reduce_high_cor_filter}
\title{Filtering highly correlated variables with reduce method}
\usage{
reduce_high_cor_filter(dat, x_list = NULL, size = ncol(dat)/10,
  p = 0.95, com_list = NULL, ex_cols = NULL, cor_class = TRUE,
  parallel = FALSE)
}
\arguments{
\item{dat}{A data.frame with independent variables.}

\item{x_list}{Names of independent variables.}

\item{size}{Size of vairable group.}

\item{p}{Threshold of correlation between features. Default is 0.7.}

\item{com_list}{A data.frame with important values of each variable. eg : IV_list}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{cor_class}{Culculate catagery variables's correlation matrix. Default is FALSE.}

\item{parallel}{Logical, parallel computing. Default is FALSE.}
}
\description{
\code{reduce_high_cor_filter} is function for filtering highly correlated variables with reduce method.
}
