% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_proc_tools.R
\name{one_hot_encoding}
\alias{one_hot_encoding}
\title{One-Hot Encoding}
\usage{
one_hot_encoding(dat, cat_vars = NULL, ex_cols = NULL,
  merge_cat = TRUE, na_act = TRUE, note = FALSE)
}
\arguments{
\item{dat}{A dat frame.}

\item{cat_vars}{The name or Column index list to be one_hot encoded.}

\item{ex_cols}{Variables to be  excluded, use regular expression matching}

\item{merge_cat}{Logical. If TRUE, to merge categories greater than 8, default is TRUE.}

\item{na_act}{Logical,If true, the missing value is processed, if FALSE missing value is omitted .}

\item{note}{Logical.Outputs info.Default is TRUE.}
}
\value{
A dat frame with the one hot encoding applied to all the variables with type as factor or character.
}
\description{
\code{one_hot_encoding} is for converting the factor or character variables into multiple columns
}
\examples{
dat1 = one_hot_encoding(dat = UCICreditCard,
cat_vars = c("SEX", "MARRIAGE"),
merge_cat = TRUE, na_act = TRUE)
dat2 = de_one_hot_encoding(dat_one_hot = dat1,
cat_vars = c("SEX","MARRIAGE"), na_act = FALSE)

}
\seealso{
\code{\link{de_one_hot_encoding}}
}
