% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{get_graph_all_packages}
\alias{get_graph_all_packages}
\title{Graph of dependencies of all CRAN packages}
\usage{
get_graph_all_packages(type, gc = TRUE, reverse = FALSE)
}
\arguments{
\item{type}{A character vector that contains one or more of the following dependency words: "Depends", "Imports", "LinkingTo", "Suggests", "Enhances", up to letter case and space replaced by underscore. Alternatively, if 'types = "all"', all five dependencies will be obtained.}

\item{gc}{Boolean, if 'TRUE' (default) then the giant component is extracted, if 'FALSE' then the whole graph is returned}

\item{reverse}{Boolean, whether forward (FALSE, default) or reverse (TRUE) dependencies are requested.}
}
\value{
An igraph object & a connected graph if gc is 'TRUE'
}
\description{
\code{get_graph_all_packages} returns an igraph object representing the network of one or more types of dependencies of all CRAN packages.
}
\examples{
\dontrun{
g0.cran.depends <- get_graph_all_packages("depends")
g1.cran.imports <- get_graph_all_packages("imports", reverse = TRUE)
}
}
\seealso{
\code{\link{get_dep_all_packages}} for the dependencies of all CRAN packages in a data frame, and \code{\link{df_to_graph}} for constructing the giant component of the network from two data frames
}
