% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrumcolors.R
\name{spectrumcolors}
\alias{spectrumcolors}
\title{Spectrum colour palette}
\usage{
spectrumcolors(n, alpha = 1, rev = FALSE)
}
\arguments{
\item{n}{integer number of colors in the scale}

\item{alpha}{alpha transparency value (0=fully transparent, 1=fully opaque)}

\item{rev}{logical flag indicating whether the ordering of the colors should be reversed}
}
\value{
Returns an n-vector of RGB colour strings.
}
\description{
Generates smooth rainbow color scale from red to purple, similar to \code{\link[grDevices]{rainbow}}, but with improved smoothness
}
\author{
Danail Obreschkow

#' @examples
nplot()
rasterImage(rbind(spectrumcolors(1e3)),0,0,1,0.5)
rasterImage(rbind(rainbow(1e3,end=5/6)),0,0.5,1,1)
text(0.5,0.25,'spectrum')
text(0.5,0.75,'rainbow')
abline(h=0.5)
}
