% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02c_kmeans_color_clustering.R
\name{extractClusters}
\alias{extractClusters}
\title{Extract cluster values and sizes from kmeans fit objects}
\usage{
extractClusters(getKMeansListObject, ordering = TRUE, normalize = FALSE)
}
\arguments{
\item{getKMeansListObject}{A list of \code{\link[stats]{kmeans}} fit objects
(especially as returned by getKMeansList).}

\item{ordering}{Logical. Should clusters by reordered by color similarity? If
\code{TRUE}, the Hungarian algorithm via \code{\link[clue]{solve_LSAP}} is
applied to find the minimum sum of Euclidean distances between color pairs
for every pair of cluster objects and colors are reordered accordingly.}

\item{normalize}{Logical. Should each cluster be normalized to show R:G:B or
H:S:V ratios rather than absolute values? Can be helpful for inconsistent
lighting, but reduces variation. See \code{\link{normalizeRGB}}.}
}
\value{
A list of dataframes (same length as input list), each with 4
  columns: R, G, B (or H, S, V) and Pct (cluster size), with one row per
  cluster.
}
\description{
Extract a list of dataframes with the same format as those returned by
\code{\link{getHistList}}, where each dataframe has 3 color attributes (R, G,
B or H, S, V) and a size attribute (Pct) for every cluster.
}
\note{
Names are inherited from the list passed to the function.
}
\examples{
clusterList <- colordistance::getKMeansList(system.file("extdata",
"Heliconius/Heliconius_A", package="colordistance"), bins=3)

colordistance::extractClusters(clusterList)
}
