% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order_methods.R
\name{f_auc}
\alias{f_auc}
\alias{f_auc_glm_binomial}
\alias{f_auc_glm_binomial_poly2}
\alias{f_auc_gam_binomial}
\alias{f_auc_rpart}
\alias{f_auc_rf}
\title{Association Between a Binomial Response and a Continuous Predictor}
\usage{
f_auc_glm_binomial(df)

f_auc_glm_binomial_poly2(df)

f_auc_gam_binomial(df)

f_auc_rpart(df)

f_auc_rf(df)
}
\arguments{
\item{df}{(required, data frame) with columns:
\itemize{
\item "x": (numeric) continuous predictor.
\item "y" (integer) binomial response with unique values 0 and 1.
}}
}
\description{
These functions take a data frame with a binomial response "y" with unique values 1 and 0, and a continuous predictor "x", fit a univariate model, to return the Area Under the ROC Curve (AUC) of observations versus predictions:
\itemize{

\item \code{f_auc_glm_binomial()}: AUC of a binomial response against the predictions of a GLM model with formula \code{y ~ x}, family \code{stats::quasibinomial(link = "logit")}, and weighted cases (see \code{\link[=case_weights]{case_weights()}}) to control for unbalanced data.

\item \code{f_auc_glm_binomial_poly2()}: AUC of a binomial response against the predictions of a GLM model with formula \code{y ~ stats::poly(x, degree = 2, raw = TRUE)}, family \code{stats::quasibinomial(link = "logit")}, and weighted cases (see \code{\link[=case_weights]{case_weights()}}) to control for unbalanced data.

\item \code{f_auc_gam_binomial()}: AUC  of a GAM model with formula  \code{y ~ s(x)}, family \code{stats::quasibinomial(link = "logit")}, and weighted cases.

\item \code{f_auc_rpart()}: AUC of a Recursive Partition Tree with weighted cases.

\item \code{f_auc_rf()}: AUC of a Random Forest model with weighted cases.
}
}
\examples{
#load example data
data(vi)

#reduce size to speed-up example
vi <- vi[1:1000, ]

#integer counts response and continuous predictor
#to data frame without NAs
df <- data.frame(
  y = vi[["vi_binomial"]],
  x = vi[["swi_max"]]
) |>
  na.omit()

#AUC of GLM with binomial response and weighted cases
f_auc_glm_binomial(df = df)

#AUC of GLM as above plus second degree polynomials
f_auc_glm_binomial_poly2(df = df)

#AUC of binomial GAM with weighted cases
f_auc_gam_binomial(df = df)

#AUC of recursive partition tree with weighted cases
f_auc_rpart(df = df)

#AUC of random forest with weighted cases
f_auc_rf(df = df)
}
\seealso{
Other preference_order_functions: 
\code{\link{f_r2}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_r2}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_r2}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_r2}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_r2}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_r2}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}
}
\concept{preference_order_functions}
