# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Count the number of lines in a file
#'
#' @useDynLib collUtils
#' @importFrom Rcpp sourceCpp evalCpp
#' @param fn Input filepath
#' @return A integer for the number of lines
#' @export
countlines <- function(fn) {
    .Call('collUtils_countlines', PACKAGE = 'collUtils', fn)
}

#' Counts the number of columns of whitespace delimited file.
#'
#' @param fn Input filepath
#' @return A integer for the number of columns
#' @export
ncols <- function(fn) {
    .Call('collUtils_ncols', PACKAGE = 'collUtils', fn)
}

#' Read one column of a whitespace delimited text file
#'
#' @param fileName Input filepath
#' @param colNum An integer. The target column number
#' @param nSkip An integer. Number of lines to skip in the beginning. 
#' @param maxRowNum An Integer. Maximum number of lines to read
#' @return A vector of strings containing the target column
#' @export
readcol <- function(fileName, colNum, nSkip, maxRowNum) {
    .Call('collUtils_readcol', PACKAGE = 'collUtils', fileName, colNum, nSkip, maxRowNum)
}

#' Read columns of a whitespace delimited text file
#'
#' @param fn input filepath
#' @param colsel a vector of target column numbers
#' @param nFirstSkipLines Integer. Number of lines to skip in the beginning
#' @param nSkipUnit Integer M. Let the function read one line out of every M
#' @return A matrix of strings from selected columns
#' @export
readcols <- function(fn, colsel, nFirstSkipLines, nSkipUnit) {
    .Call('collUtils_readcols', PACKAGE = 'collUtils', fn, colsel, nFirstSkipLines, nSkipUnit)
}

