% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{clustra_sil}
\alias{clustra_sil}
\title{clustra_sil: Prepare silhouette plot data for several k or for a previous
clustra run}
\usage{
clustra_sil(
  data,
  kv = NULL,
  starts = "random",
  mccores = 1,
  maxdf = 30,
  conv = c(10, 0),
  save = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame (see the \code{data} parameter of \code{\link{trajectories}}).
Alternatively, the output from a completed \code{clustra} run can be used, in
which case \code{kv} is left as \code{NULL}. See Details.}

\item{kv}{Vector of \code{clustra} \code{k} values to run. If \code{data} is the output from a
completed \code{clustra} run, leave \code{kv} as NULL.}

\item{starts}{See \code{\link{clustra}}.}

\item{mccores}{See \code{\link{trajectories}}.}

\item{maxdf}{Fitting parameters. See \code{\link{trajectories}}.}

\item{conv}{Fitting parameters. See \code{\link{trajectories}}.}

\item{save}{Logical. When TRUE, save all results as file \code{clustra_sil.Rdata}.}

\item{verbose}{Logical. When TRUE, information about each run of clustra is printed.}
}
\value{
Invisibly returns a list of length \code{length(kv)}, where each element is
a matrix with \code{nrow(data)} rows and three columns \code{cluster}, \code{neighbor},
\code{silhouette}. The matrix in each element of this list can be used to draw a
silhouette plot. When the input was a completed \code{clustra} run, the output is a
list with a single element for a single silhouette plot.
}
\description{
Performs \code{\link{clustra}} runs for several k and prepares silhouette
plot data. Computes a proxy silhouette index based on distances to cluster
centers rather than trajectory pairs. The cost is essentially that of
running clustra for several k as this information is available directly from
clustra. Can also reuse a previous clustra run and produce data for a single
silhouette plot.
}
\details{
When given the raw data as the first parameter (input \code{data} parameter of
\code{\link{trajectories}}), \code{kv} specifies a vector of \code{k} parameters for
\code{clustra} and produces data for silhouette plots of each of them.
Alternatively, the input can be the output from a single \code{clustra} run, in
which case data for a single silhouette plot will be made without running
\code{clustra}.
}
