% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processResults.R
\name{coclusteringMatrix}
\alias{coclusteringMatrix}
\title{Compute the posterior co-clustering matrix from global cluster assignments.}
\usage{
coclusteringMatrix(assignments)
}
\arguments{
\item{assignments}{Matrix of cluster assignments, where each row
corresponds to cluster assignments sampled in one MCMC iteration}
}
\value{
Posterior co-clustering matrix, where element \code{[i,j]} represents
    the posterior probability that data points \code{i} and \code{j} belong
    to the same cluster.
}
\description{
Compute the posterior co-clustering matrix from global cluster assignments.
}
\examples{
# Generate simple test dataset
groupCounts <- c(50, 10, 40, 60)
means <- c(-1.5,1.5)
testData <- generateTestData_2D(groupCounts, means)
datasets <- testData$data

# Fit the model
# 1. specify number of clusters
clusterCounts <- list(global=10, context=c(3,3))
# 2. Run inference
# Number of iterations is just for demonstration purposes, use
# a larger number of iterations in practice!
results <- contextCluster(datasets, clusterCounts,
     maxIter = 10, burnin = 5, lag = 1,
     dataDistributions = 'diagNormal',
     verbose = TRUE)

# Extract only the sampled global assignments
samples <- results$samples
clusters <- plyr::laply(1:length(samples), function(i) samples[[i]]$Global)
coclusteringMatrix(clusters)

}

