% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcloud-storage.R
\name{gs_rsync}
\alias{gs_rsync}
\title{Synchronize content of two buckets/directories}
\usage{
gs_rsync(source, destination, delete = FALSE, recursive = FALSE,
  parallel = TRUE, dry_run = FALSE, options = NULL, echo = TRUE)
}
\arguments{
\item{source}{The file to be copied. This can be either a path on the local
filesystem, or a Google Storage URI (e.g. \code{gs://[BUCKET_NAME]/[FILENAME.CSV]}).}

\item{destination}{The location where the \code{source} file should be copied to. This can be
either a path on the local filesystem, or a Google Storage URI (e.g.
\code{gs://[BUCKET_NAME]/[FILENAME.CSV]}).}

\item{delete}{Delete extra files under \code{destination} not found under
\code{source} By default extra files are not deleted.}

\item{recursive}{Causes directories, buckets, and bucket subdirectories to
be synchronized recursively. If you neglect to use this option
\code{gs_rsync()} will make only the top-level directory in the source and
destination URLs match, skipping any sub-directories.}

\item{parallel}{Causes synchronization to run in parallel. This can
significantly improve performance if you are performing operations on a
large number of files over a reasonably fast network connection.}

\item{dry_run}{Causes rsync to run in "dry run" mode, i.e., just outputting
what would be copied or deleted without actually doing any
copying/deleting.}

\item{options}{Character vector of additional command line options to the
gsutil rsync command (as specified at
\url{https://cloud.google.com/storage/docs/gsutil/commands/rsync}).}

\item{echo}{Echo command output to console.}
}
\description{
The \code{gs_rsync} function makes the contents under \code{destination} the same
as the contents under \code{source}, by copying any missing files/objects (or
those whose data has changed), and (if the \code{delete} option is specified)
deleting any extra files/objects. \code{source} must specify a directory, bucket,
or bucket subdirectory.
}
