% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{jobs_put_archive}
\alias{jobs_put_archive}
\title{Update the archive status of this object}
\usage{
jobs_put_archive(id, status)
}
\arguments{
\item{id}{integer required. The ID of the object.}

\item{status}{boolean required. The desired archived status of the object.}
}
\value{
A list containing the following elements:
\item{id}{integer, }
\item{name}{string, }
\item{type}{string, }
\item{fromTemplateId}{integer, }
\item{state}{string, Whether the job is idle, queued, running, cancelled, or failed.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{runs}{array, An array containing the following fields: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{hidden}{boolean, The hidden status of the item.}
\item{archived}{string, The archival status of the requested item(s).}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
\item{successEmailSubject}{string, }
\item{successEmailBody}{string, }
\item{runningAsUser}{string, }
\item{runByUser}{string, }
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Days of the week, based on numeric value starting at 0 for Sunday. Mutually exclusive with scheduledDaysOfMonth
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Deprecated in favor of scheduled minutes.
\item scheduledDaysOfMonth array, Days of the month it is scheduled on, mutually exclusive with scheduledDays.
}}
}
\description{
Update the archive status of this object
}
