% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{ccHeatmapLink}
\alias{ccHeatmapLink}
\title{Draw a link between two matrix rows in the circular heatmap}
\usage{
ccHeatmapLink(row_from, row_to, ...)
}
\arguments{
\item{row_from}{The row index where the link starts. The value should be length 1. If you want to draw multiple links, put the function in a \code{for} loop.}

\item{row_to}{The row index where the link ends.}

\item{...}{Pass to \code{\link[circlize]{circos.link}}.}
}
\value{
Object \linkS4class{ccHeatmapLink}
}
\description{
Object \linkS4class{ccHeatmapLink} will call the function \link[circlize:circos.heatmap.link]{circlize::circos.heatmap.link} while drawing.
}
\examples{
\donttest{
library(circlizePlus)
set.seed(123)
mat = matrix(rnorm(100*10), nrow = 100)
rownames(mat) = paste0("R", 1:100)
col_fun = colorRamp2(c(-2, 0, 2), c("blue", "white", "red"))
cc = ccHeatmap(mat, col = col_fun, rownames.side = "outside")
link1 = ccHeatmapLink(10, 60)
cc + link1
}
}
