\name{segmentCIM}
\alias{segmentCIM}

\title{
Segments a 1D contact profile (1D CIM)
}
\description{
This function finds changes points in a 1D Hi-C contact profile generated by 
taking the row sums of a pairwise chromosomal interactions map (CIM).
It applies a wavelet change point algorithm [1] in order to find the location of
change points (the segmentation of the profile).
}
\usage{
segmentCIM(y, minL = 1, maxL = 1)
}
\arguments{
  \item{y}{
A 1D Hi-C contact profile (a vector generated by taking row sums of a pairwise 
chromosomal interactions map (CIM)). 
}
  \item{minL}{
Optional: a positive integer specifying the minimum level at which the search 
should be carried out. Set to 1 by default
}
  \item{maxL}{
Optional: a positive integer specifying the maximum level at which the search 
should be carried out and set to 1 by default. 
Should not exceed 0.1 of the length of the input. If the algorithm cannot find 
change points at the minimum level, it will repeat 
the search at higher levels and stop at the first level where change points were
found or when it has reached the maximum level.
}
}
\details{
This function implemments a wavelet change point algorithm as described in [1] 
and based on its matlab implementation (http://homepages.
ulb.ac.be/~majansen/software/index.html)
}
\value{
Returns a list including the following objects:
\item{changePoints }{the location of change points (or NULL if none were found)}
\item{L }{the level at which the change points were found (or the given maximal 
level if no change points were found)}
}
\references{
website: http://www.cl.cam.ac.uk/~ys388/chromoR/ (including more examples and 
data sets)

[1] M. Jansen, Chemometrics and intelligent laboratory systems, 2007, 85, 159.
}
\author{
Yoli Shavit
}
\seealso{
See Also as \code{\link{compareCIM}}
}
\examples{
data(imr90.1) # corrected contact map of imr90 (replicate 1) for chromosomes 1,2 
data(seg)
#generate a 1D profile for cis CIM of chromosome 2
indices = which(seg$chr == "chr2")
i1 = indices[1]
iN = indices[length(indices)]
p = rowSums(imr90.1[i1:iN, i1:iN]) - diag(imr90.1[i1:iN, i1:iN])
res = segmentCIM(p)
res
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
