% Generated by roxygen2 (4.0.2): do not edit by hand
\name{county_zoom_choropleth}
\alias{county_zoom_choropleth}
\title{Create a choropleth of USA Counties, with sensible defaults, that zooms on counties.}
\usage{
county_zoom_choropleth(df, title = "", legend = "", buckets = 7,
  zoom = NULL)
}
\arguments{
\item{df}{A data.frame with a column named "region" and a column named "value".  Elements in
the "region" column must exactly match how regions are named in the "region" column in county.map.}

\item{title}{An optional title for the map.}

\item{legend}{An optional name for the legend.  Ignored if zooming in on a single county.}

\item{buckets}{The number of equally sized buckets to places the values in.  A value of 1
will use a continuous scale, and a value in [2, 9] will use that many buckets. Ignored if
zooming in on a single county.}

\item{zoom}{An optional vector of counties to zoom in on. Elements of this vector must exactly
match the names of counties as they appear in the "region" column of ?county.regions.}
}
\description{
The map used is county.map in the choroplethrMaps package.  See country.regions
in the choroplethrMaps package for an object which can help you coerce your regions
into the required format. If you zoom in on a single county, only an outline of the
county is shown.
}
\examples{
\dontrun{

library(choroplethrMaps)
data(county.regions)

library(dplyr)

# show the population of the 5 counties (boroughs) that make up New York City
nyc_county_names=c("kings", "bronx", "new york", "queens", "richmond")
nyc_county_fips = county.regions \%>\%
  filter(state.name=="new york" & county.name \%in\% nyc_county_names) \%>\%
  select(region)
county_zoom_choropleth(df_pop_county,
                       title="Population of Counties in New York City",
                       legend="Population",
                       buckets=1,
                       zoom=nyc_county_fips$region)

# zooming in on a single county shows just an outline.
county_zoom_choropleth(df_pop_county,
                       title="Zoom of Manhattan",
                       zoom=36061) # manhattan

# population of the 9 counties in the san francisco bay area
bay_area_county_names = c("alameda", "contra costa", "marin", "napa", "san francisco",
                          "san mateo", "santa clara", "solano", "sonoma")
bay_area_county_fips = county.regions \%>\%
  filter(state.name=="california" & county.name \%in\% bay_area_county_names) \%>\%
  select(region)
county_zoom_choropleth(df_pop_county,
                       title="Population of Counties in the San Francisco Bay Area",
                       legend="Population",
                       buckets=1,
                       zoom=bay_area_county_fips$region)
}
}

