% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{setdiff_}
\alias{setdiff_}
\alias{intersect_}
\alias{cut_numeric}
\alias{\%in_\%}
\alias{\%!in_\%}
\alias{enframe_}
\alias{deframe_}
\alias{sample_}
\alias{val_insert}
\alias{na_insert}
\alias{vector_length}
\alias{cheapr_var}
\alias{cheapr_rev}
\alias{with_local_seed}
\title{Extra utilities}
\usage{
setdiff_(x, y, dups = TRUE)

intersect_(x, y, dups = TRUE)

cut_numeric(
  x,
  breaks,
  labels = NULL,
  include.lowest = FALSE,
  right = TRUE,
  dig.lab = 3L,
  ordered_result = FALSE,
  ...
)

x \%in_\% table

x \%!in_\% table

enframe_(x, name = "name", value = "value")

deframe_(x)

sample_(x, size = vector_length(x), replace = FALSE, prob = NULL)

val_insert(x, value, n = NULL, prop = NULL)

na_insert(x, n = NULL, prop = NULL)

vector_length(x)

cheapr_var(x, na.rm = TRUE)

cheapr_rev(x)

with_local_seed(expr, .seed = NULL, ...)
}
\arguments{
\item{x}{A vector or data frame.}

\item{y}{A vector or data frame.}

\item{dups}{Should duplicates be kept? Default is \code{TRUE}.}

\item{breaks}{See \code{?cut}.}

\item{labels}{See \code{?cut}.}

\item{include.lowest}{See \code{?cut}.}

\item{right}{See \code{?cut}.}

\item{dig.lab}{See \code{?cut}.}

\item{ordered_result}{See \code{?cut}.}

\item{...}{Further arguments passed onto \code{cut} or \code{set.seed}.}

\item{table}{See \code{?collapse::fmatch}}

\item{name}{The column name to assign the names of a vector.}

\item{value}{The column name to assign the values of a vector.}

\item{size}{See \code{?sample}.}

\item{replace}{See \code{?sample}.}

\item{prob}{See \code{?sample}.}

\item{n}{Number of scalar values (or \code{NA}) to insert
randomly into your vector.}

\item{prop}{Proportion of scalar values (or \code{NA}) values to insert
randomly into your vector.}

\item{na.rm}{Should \code{NA} values be ignored in \code{cheapr_var()} Default is
\code{TRUE}.}

\item{expr}{Expression that will be evaluated with a local seed that
is independent and has absolutely no effect on the global RNG state.}

\item{.seed}{A local seed to set which is only used inside
\code{with_local_seed()}. After the execution of the expression the original
seed is reset.}
}
\value{
\verb{enframe()_} converts a vector to a data frame. \cr
\verb{deframe()_} converts a 1-2 column data frame to a vector. \cr
\code{intersect_()} returns a vector of common values between \code{x} and \code{y}. \cr
\code{setdiff_()} returns a vector of values in \code{x} but not \code{y}. \cr
\code{cut_numeric()} places values of a numeric vector into buckets, defined
through the \code{breaks} argument and returns a factor unless \code{labels = FALSE},
in which case an integer vector of break indices is returned. \cr
\verb{\%in_\%} and \verb{\%!in_\%} both return a logical vector signifying if the values of
\code{x} exist or don't exist in \code{table} respectively. \cr
\code{sample_()} is an alternative to \code{sample()} that natively samples
data frame rows through \code{sset()}. It also does not have a special case when
\code{length(x)} is 1. \cr
\code{val_insert} inserts scalar values randomly into your vector.
Useful for replacing lots of data with a single value. \cr
\code{na_insert} inserts \code{NA} values randomly into your vector.
Useful for generating missing data. \cr
\code{vector_length} behaves mostly like \code{NROW()} except
for matrices in which it matches \code{length()}.
\code{cheapr_var} returns the variance of a numeric vector.
No coercion happens for integer vectors and so is very cheap. \cr
\code{cheapr_rev} is a much cheaper version of \code{rev()}. \cr
\code{with_local_seed} offers no speed improvements but is extremely handy
in executing random number based expressions like \code{rnorm()} without
affecting the global RNG state. It allows you to run these expressions in a
sort of independent 'container' and with an optional seed for that
'container' for reproducibility.
The rationale for including this in 'cheapr' is that it can reduce the need
to set many seed values,
especially for multiple output comparisons of RNG expressions.
Another way of thinking about it is that \code{with_local_seed()} is a helper
that allows you to write reproducible code without side-effects, which
traditionally cannot be avoided when calling \code{set.seed()} directly.
}
\description{
Extra utilities
}
\examples{
library(cheapr)

# Using `with_local_seed()`

# The below 2 statements are equivalent

# Statement 1
set.seed(123456789)
res <- rnorm(10)

# Statement 2
res2 <- with_local_seed(rnorm(10), .seed = 123456789)

# They are the same
identical(res, res2)

# As an example we can see that the RNG is unaffected by generating
# random uniform deviates in batches between calls to `with_local_seed()`
# and comparing to the first result

set.seed(123456789)
batch1 <- rnorm(2)

with_local_seed(runif(10))
batch2 <- rnorm(2)
with_local_seed(runif(10))
batch3 <- rnorm(1)
with_local_seed(runif(10))
batch4 <- rnorm(5)

# Combining the batches produces the same result
# therefore `with_local_seed` did not interrupt the rng sequence
identical(c(batch1, batch2, batch3, batch4), res)

# It can be useful in multiple comparisons
out1 <- with_local_seed(rnorm(5))
out2 <- with_local_seed(rnorm(5))
out3 <- with_local_seed(rnorm(5))

identical(out1, out2)
identical(out1, out3)

}
