% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_cnt.R
\name{geom_cnt_text}
\alias{geom_cnt_text}
\alias{geom_cnt_label}
\title{Plot label or text on centerline with ggplot2}
\usage{
geom_cnt_text(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "sf",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  keep = 0.5,
  method = c("voronoi", "straight"),
  simplify = TRUE,
  ...
)

geom_cnt_label(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "sf",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  keep = 0.5,
  method = c("voronoi", "straight"),
  simplify = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.

You can also set this to one of "polygon", "line", and "point" to
override the default legend.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{keep}{numeric, proportion of points to retain (0.05-5.0; default 0.5).
See Details.}

\item{method}{character, either \code{"voronoi"} (default) or
\code{"straight"}, or just the first letter \code{"v"} or \code{"s"}.
See Details.}

\item{simplify}{logical, if \code{TRUE} (default) then the
centerline will be smoothed with \code{\link[smoothr:smooth_ksmooth]{smoothr::smooth_ksmooth()}}}

\item{...}{
  Arguments passed on to \code{\link[geomtextpath:geom_textpath]{geom_textpath}}, \code{\link[geomtextpath:geom_labelpath]{geom_labelpath}}
  \describe{
    \item{\code{text_only}}{A \code{logical(1)} indicating whether the path part should be
plotted along with the text (\code{FALSE}, the default). If \code{TRUE}, any
parameters or aesthetics relating to the drawing of the path will be
ignored.}
    \item{\code{gap}}{A \code{logical(1)} which if \code{TRUE}, breaks the path into two sections
with a gap on either side of the label. If \code{FALSE}, the path is plotted
as a whole. Alternatively, if \code{NA}, the path will be broken if the string
has a \code{vjust} between 0 and 1, and not otherwise. The default for the label
variant is \code{FALSE} and for the text variant is \code{NA}.}
    \item{\code{upright}}{A \code{logical(1)} which if \code{TRUE} (default), inverts any text
where the majority of letters would upside down along the path, to improve
legibility. If \code{FALSE}, the path decides the orientation of text.}
    \item{\code{halign}}{A \code{character(1)} describing how multi-line text should be
justified. Can either be \code{"center"} (default), \code{"left"} or \code{"right"}.}
    \item{\code{offset}}{A \code{\link[grid:unit]{unit}} object of length 1 to determine the
offset of the text from the path. If this is \code{NULL} (default), the \code{vjust}
parameter decides the offset. If not \code{NULL}, the \code{offset} argument
overrules the \code{vjust} setting.}
    \item{\code{parse}}{A \code{logical(1)} which if \code{TRUE}, will coerce the labels into
expressions, allowing for plotmath syntax to be used.}
    \item{\code{straight}}{A \code{logical(1)} which if \code{TRUE}, keeps the letters of a label
on a straight baseline and if \code{FALSE} (default), lets individual letters
follow the curve. This might be helpful for noisy paths.}
    \item{\code{padding}}{A \code{\link[grid:unit]{unit}} object of length 1 to determine the
padding between the text and the path when the \code{gap} parameter trims the
path.}
    \item{\code{text_smoothing}}{a \code{numeric(1)} value between 0 and 100 that smooths
the text without affecting the line portion of the geom. The default value
of \code{0} means no smoothing is applied.}
    \item{\code{rich}}{A \code{logical(1)} whether to interpret the text as html/markdown
formatted rich text. Default: \code{FALSE}. See also the rich text section of
the details in \code{\link[geomtextpath:geom_textpath]{geom_textpath()}}.}
    \item{\code{label.padding}}{Amount of padding around label. Defaults to 0.25 lines.}
    \item{\code{label.r}}{Radius of rounded corners. Defaults to 0.15 lines.}
  }}
}
\description{
Binding for \code{\link[geomtextpath:geom_textsf]{geomtextpath::geom_textsf()}} and
\code{\link[geomtextpath:geom_textsf]{geomtextpath::geom_labelsf()}}
}
\details{
\subsection{Aesthetics}{

\code{geom_cnt_text()} understands the following aesthetics:
\itemize{
\item \code{x}
\item \code{y}
\item \code{label}
\item \code{alpha}
\item \code{angle}
\item \code{colour}
\item \code{family}
\item \code{fontface}
\item \code{group}
\item \code{hjust}
\item \code{linecolour}
\item \code{lineheight}
\item \code{linetype}
\item \code{linewidth}
\item \code{size}
\item \code{spacing}
\item \code{textcolour}
\item \code{vjust}
}

In addition to aforementioned aesthetics, \code{geom_cnt_label()} also
understands:
\itemize{
\item \code{boxcolour}
\item \code{boxlinetype}
\item \code{boxlinewidth}
\item \code{fill}
}
}
}
\examples{
\dontshow{if (requireNamespace("geomtextpath", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(sf)
library(ggplot2)

lake <-
  sf::st_read(
    system.file("extdata/example.gpkg", package = "centerline"),
    layer = "lake",
    quiet = TRUE
  )

# Plot centerline and lake name as text
ggplot() +
  geom_sf(data = lake) +
  geom_cnt_text(
    data = lake,
    aes(label = "Lake Ohau"),
    size = 8,
    simplify = TRUE
  ) +
theme_void()

# Plot lake name as label
ggplot() +
  geom_sf(data = lake) +
  geom_cnt_label(
    data = lake,
    aes(label = "Lake Ohau"),
    linecolor = NA, # disable line drawing
    size = 10,
    method = "s",
    simplify = TRUE
  ) +
theme_void()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=geom_cnt]{geom_cnt()}}, \code{\link[geomtextpath:geom_textsf]{geomtextpath::geom_textsf()}},
\code{\link[geomtextpath:geom_textsf]{geomtextpath::geom_labelsf()}}, \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}
}
