% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_symbol.R
\name{as_symbol}
\alias{as_symbol}
\title{Convert object to symbol}
\usage{
as_symbol(x, declare_variables = TRUE)
}
\arguments{
\item{x}{R object to convert to a symbol}

\item{declare_variables}{declare detected variables automatically}
}
\description{
Variables are detected as a
character followed by a number of either:
character, number or underscore.
}
\details{
Default is to declare used variables. Alternatively, the user
must declare them first, e.g. by \code{\link[=symbol]{symbol()}}.

Note that matrices can be defined by specifying a Python matrix,
see below in examples.
}
\examples{
if (have_sympy()) {
  x <- symbol("x")
  A <- matrix(c("x", 0, 0, "2*x"), 2, 2)
  A
  B <- as_symbol(A)
  B
  2*B
  dim(B)
  sqrt(B)
  D <- as_symbol("[[1, 4, 5], [-5, 8, 9]]")
  D
}

}
\concept{caracas_symbol}
