% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/can_lm.R
\name{can_lm}
\alias{can_lm}
\title{Transform a Multivariate Linear model \code{mlm} to a Canonical Representation}
\usage{
can_lm(mod, term, ...)
}
\arguments{
\item{mod}{A \code{mlm} object}

\item{term}{One term in that model}

\item{\dots}{Arguments passed to \code{\link[=candisc]{candisc()}}}
}
\value{
A \code{lm} object if \code{term} is a rank 1 hypothesis, otherwise a \code{mlm} object
}
\description{
This function uses \code{\link[=candisc]{candisc()}} to transform the responses in a
multivariate linear model to scores on canonical variables for a given term and then uses
those scores as responses in a linear (lm) or multivariate linear model (mlm).

The function constructs a model formula of the form \code{Can ~ terms} where
Can is the canonical score(s) and terms are the terms in the original mlm,
then runs lm() with that formula.
}
\examples{

iris.mod <- lm(cbind(Petal.Length, Sepal.Length, Petal.Width, Sepal.Width) ~ Species, data=iris)
iris.can <- can_lm(iris.mod, "Species")
iris.can
car::Anova(iris.mod)
car::Anova(iris.can)

}
\seealso{
\code{\link[=candisc]{candisc()}}, \code{\link[=cancor]{cancor()}}
}
\author{
Michael Friendly
}
