% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardized_incidence_rate_difference.R
\name{standardized_incidence_rate_difference}
\alias{standardized_incidence_rate_difference}
\title{Age-standardized incidence rates differences (asird)}
\usage{
standardized_incidence_rate_difference(
  ncan,
  py,
  ncanref,
  pyref,
  pystd,
  ncan.min = 5
)
}
\arguments{
\item{ncan}{integer, (age-specific) number of cancers in the population of interest}

\item{py}{integer, (age-specific) person-year in the the population of interest}

\item{ncanref}{integer, (age-specific) number of cancers in the reference population}

\item{pyref}{integer, (age-specific) person-year in the the reference population}

\item{pystd}{numeric, (age-specific) standard population person-years (e.g. standard world population)}

\item{ncan.min}{integer, minimum number of observation required not to mask the CI's out

Age-standardized incidence rate difference (asird) is computed without confidence interval estimation for now.
asird is a summary statistics that should be computed per group of individuals providing age specific counts.}
}
\value{
a 1 line and 3 column data.frame containing the pir (est) and associated 95\% CI (lci, uci)
}
\description{
Age-standardized incidence rates differences (asird)
}
\examples{
ncan <- 1:10
py <- 101:110
ncanref <- 41:50
pyref <- 251:260
pystd <- 10:1
ncan.min <- 5
standardized_incidence_rate_difference(ncan, py, ncanref, pyref, pystd, ncan.min)
standardized_incidence_rate_difference(ncan, py, ncanref, pyref, pystd, sum(ncan) + 1)
}
\references{
https://www.hsph.harvard.edu/thegeocodingproject/analytic-methods/
}
\concept{summary-stat}
