% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksvm.R
\name{axe-ksvm}
\alias{axe-ksvm}
\alias{axe_call.ksvm}
\alias{axe_data.ksvm}
\alias{axe_fitted.ksvm}
\title{Axing a ksvm object.}
\usage{
\method{axe_call}{ksvm}(x, verbose = FALSE, ...)

\method{axe_data}{ksvm}(x, verbose = FALSE, ...)

\method{axe_fitted}{ksvm}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed ksvm object.
}
\description{
ksvm objects are created from \pkg{kernlab} package, which provides
a means to do classification, regression, clustering, novelty
detection, quantile regression and dimensionality reduction. Since
fitted model objects from \pkg{kernlab} are S4, the \code{butcher_ksvm}
class is not appended.
}
\examples{
\dontshow{if (rlang::is_installed(c("parsnip", "kernlab"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Load libraries
library(parsnip)
library(kernlab)

# Load data
data(spam)

# Create model and fit
ksvm_class <- svm_poly(mode = "classification") \%>\%
  set_engine("kernlab") \%>\%
  fit(type ~ ., data = spam)

out <- butcher(ksvm_class, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
