% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{autoplot.bumbldf}
\alias{autoplot.bumbldf}
\title{Plot observed and fitted results from bumbl()}
\usage{
\method{autoplot}{bumbldf}(object, ..., colony = NULL, x = deprecated())
}
\arguments{
\item{object}{a dataframe produced by \code{\link[=bumbl]{bumbl()}}}

\item{...}{other arguments passed to \code{autoplot()}}

\item{colony}{a character vector of colony IDs to plot}

\item{x}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{x} has been re-named to \code{object}
for consistency with other \code{autoplot()} functions}
}
\value{
invisibly returns a ggplot object
}
\description{
Plots observed (points) and fitted (red line) values from the model implemented by \code{bumbl()}, faceted by colony.
}
\examples{
bombus_subset <- bombus[bombus$colony \%in\% c("17", "104", "20", "24"), ]
results <- bumbl(bombus_subset, colonyID = colony, t = week,
                 formula = mass ~ week)
library(ggplot2)
autoplot(results)
}
