% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.SDDRidSV}
\alias{summary.SDDRidSV}
\title{Provides summary of verifying homoskedasticity}
\usage{
\method{summary}{SDDRidSV}(object, ...)
}
\arguments{
\item{object}{an object of class \code{SDDRidSV} obtained using the
\code{\link{verify_identification.PosteriorBSVARSV}} function.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A table reporting the logarithm of Bayes factors of homoskedastic to
heteroskedastic posterior odds \code{"log(SDDR)"} for each structural shock, 
their numerical standard errors \code{"NSE"}, and the implied posterior 
probability of the homoskedasticity and heteroskedasticity hypothesis, 
\code{"Pr[homoskedasticity|data]"} and \code{"Pr[heteroskedasticity|data]"} 
respectively.
}
\description{
Provides summary of the Savage-Dickey density ratios
for verification of structural shocks homoskedasticity. The outcomes can be
used to make probabilistic statements about identification through 
heteroskedasticity following Lütkepohl, Shang, Uzeda & Woźniak (2024).
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_sv$new(us_fiscal_lsuw)
set.seed(123)

# estimate the model
posterior      = estimate(specification, 10)

# verify heteroskedasticity
sddr           = verify_identification(posterior)
summary(sddr)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_sv$new() |>
  estimate(S = 10) |> 
  verify_identification() |> 
  summary() -> sddr_summary

}
\references{
Lütkepohl, H., Shang, F., Uzeda, L., and Woźniak, T. (2024) Partial Identification of Heteroskedastic Structural VARs: Theory and Bayesian Inference. \emph{University of Melbourne Working Paper}, 1--57, \doi{10.48550/arXiv.2404.11057}.
}
\seealso{
\code{\link{verify_identification.PosteriorBSVARSV}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
