% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_table}
\alias{bs_table}
\title{Create a HTML table configured with Bootstrap classes}
\usage{
bs_table(
  x,
  id,
  headers = NULL,
  table_attr = list(class = "table"),
  thead_attr = NULL,
  tbody_attr = NULL,
  tr_attr = NULL,
  th_attr = list(scope = "col"),
  td_attr = NULL,
  wrapper_attr = NULL
)
}
\arguments{
\item{x}{A data frame or list with entries of equal length.}

\item{id, }{A string, the id for the table.}

\item{headers}{A vector of names to use as table headers instead of the list names (or 1, 2, 3, etc. if list is not named).}

\item{table_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::table.}

\item{thead_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::thead.}

\item{tbody_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::tbody.}

\item{tr_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::tr.}

\item{th_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::th.}

\item{td_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::td.}

\item{wrapper_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::div wrapping html5::table.}
}
\value{
A string of HTML.
}
\description{
Learn more at \url{https://getbootstrap.com/docs/5.1/content/tables/}.
}
\examples{
bs_table(
id = "t1",
x = list(
col1 = c(1, 2, 3, 4, 5),
col2 = c("a", "b", "c", "d", "e"),
col3 = c(1, 2, 3, 4, 5),
col4 = c("test", "test", "test", "test", "test")
)
)
}
