% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brxx_ICC_general.R
\name{brxx_ICC_general}
\alias{brxx_ICC_general}
\title{brxx_ICC_general: Bayesian Estimation of Reliability from ICC, General Form}
\usage{
brxx_ICC_general(WS, Resid, alpha, beta, CI, items)
}
\arguments{
\item{WS}{Within subjects variance estimate.}

\item{Resid}{Residual variance estimate.}

\item{alpha}{Prior true score variance.}

\item{beta}{Prior error variance.}

\item{CI}{Credible interval quantile, as a decimal (ie, for 95 percent, 0.95).}

\item{items}{Number of test items.}
}
\value{
Returns estimated median and quantile based credible limits for reliability.
}
\description{
This function estimates reliability from intraclass correlation given correlation.
}
\examples{
WS=20.4
Resid=3.6
alpha=3.51
beta=1.75
brxx_ICC_general(WS=WS,Resid=Resid,alpha=alpha,beta=beta,CI=0.95,items=5)

}
