% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust-lmrob.R
\name{tidy.lmRob}
\alias{tidy.lmRob}
\alias{robust_tidiers}
\title{Tidy a(n) lmRob object}
\usage{
\method{tidy}{lmRob}(x, ...)
}
\arguments{
\item{x}{A \code{lmRob} object returned from \code{\link[robust:lmRob]{robust::lmRob()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
For tidiers for robust models from the \pkg{MASS} package see
\code{\link[=tidy.rlm]{tidy.rlm()}}.
}
\examples{
\dontshow{if (rlang::is_installed("robust")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# load modeling library
library(robust)

# fit model
m <- lmRob(mpg ~ wt, data = mtcars)

# summarize model fit with tidiers
tidy(m)
augment(m)
glance(m)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[robust:lmRob]{robust::lmRob()}}

Other robust tidiers: 
\code{\link{augment.lmRob}()},
\code{\link{glance.glmRob}()},
\code{\link{glance.lmRob}()},
\code{\link{tidy.glmRob}()}
}
\concept{robust tidiers}
