% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_dim2hier.R
\name{cast_dim2hier}
\alias{cast_dim2hier}
\alias{cast_dim2hier.default}
\title{Cast Dimensional List into Hierarchical List}
\usage{
cast_dim2hier(x, ...)

\method{cast_dim2hier}{default}(x, in2out = TRUE, distr.names = FALSE, ...)
}
\arguments{
\item{x}{an array of type \code{list}.}

\item{...}{further arguments passed to or from methods. \cr \cr}

\item{in2out}{see \link{broadcast_casting}.}

\item{distr.names}{\code{TRUE} or \code{FALSE},
indicating if \code{dimnames} from \code{x} should be distributed over the nested elements of the output. \cr
See examples section for demonstration.}
}
\value{
A nested list. \cr
\cr
}
\description{
\code{cast_dim2hier()} casts a dimensional list (i.e. an array of type \code{list})
into a hierarchical/nested list. \cr
\cr
}
\examples{


x <- array(c(as.list(1:24), as.list(letters)), 4:2)
dimnames(x) <- list(
  letters[1:4],
  LETTERS[1:3],
  month.abb[1:2]
)
print(x)


# cast `x` from in to out, and distribute names:
x2 <- cast_dim2hier(x, distr.names = TRUE)
head(x2, n = 2)

# cast `x` from out to in, and distribute names:
x2 <- cast_dim2hier(x, in2out = FALSE, distr.names = TRUE)
head(x2, n = 2)
}
\seealso{
\link{broadcast_casting} \cr
}
