% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-auth.R
\name{db_host}
\alias{db_host}
\title{Generate/Fetch Databricks Host}
\usage{
db_host(id = NULL, prefix = NULL, profile = default_config_profile())
}
\arguments{
\item{id}{The workspace string}

\item{prefix}{Workspace prefix}

\item{profile}{Profile to use when fetching from environment variable
(e.g. \code{.Renviron}) or \code{.databricksfg} file}
}
\value{
workspace URL
}
\description{
If both \code{id} and \code{prefix} are \code{NULL} then the function will check for
the \code{DATABRICKS_HOST} environment variable.
\code{.databrickscfg} will be searched if \code{db_profile} and \code{use_databrickscfg} are set or if
Posit Workbench managed OAuth credentials are detected.

When defining \code{id} and \code{prefix} you do not need to specify the whole URL.
E.g. \verb{https://<prefix>.<id>.cloud.databricks.com/} is the form to follow.
}
\details{
The behaviour is subject to change depending if \code{db_profile} and
\code{use_databrickscfg} options are set.
\itemize{
\item \code{use_databrickscfg}: Boolean (default: \code{FALSE}), determines if credentials
are fetched from profile of \code{.databrickscfg} or \code{.Renviron}
\item \code{db_profile}: String (default: \code{NULL}), determines profile used.
\code{.databrickscfg} will automatically be used when Posit Workbench managed OAuth credentials are detected.
}

See vignette on authentication for more details.
}
\seealso{
Other Databricks Authentication Helpers: 
\code{\link{db_read_netrc}()},
\code{\link{db_token}()},
\code{\link{db_wsid}()}
}
\concept{Databricks Authentication Helpers}
