% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flippedBraid.R
\name{invertFlippedBraidModel}
\alias{invertFlippedBraidModel}
\alias{invertFlippedBraidModel_A}
\alias{invertFlippedBraidModel_B}
\title{Invert Flipped BRAID Surfaces}
\usage{
invertFlippedBraidModel(
  DA = NULL,
  DB = NULL,
  effect,
  bpar,
  flip,
  invalidNA = FALSE,
  lowerBound = FALSE
)

invertFlippedBraidModel_A(
  DB,
  effect,
  bpar,
  flip,
  invalidNA = FALSE,
  lowerBound = FALSE
)

invertFlippedBraidModel_B(
  DA,
  effect,
  bpar,
  flip,
  invalidNA = FALSE,
  lowerBound = FALSE
)
}
\arguments{
\item{DA}{If not \code{NULL}, a vector of doses of drug A. Must be length 1 or
the same length as \code{effect}.  Only one of \code{DA} and \code{DB} may be not null.}

\item{DB}{If not \code{NULL}, a vector of doses of drug B. Must be length 1 or
the same length as \code{effect}.  Only one of \code{DA} and \code{DB} may be not null.}

\item{effect}{A vector of desired effect values to be reached.  Must be
length 1 or the same length as whichever of \code{DA} or \code{DB} is not null.}

\item{bpar}{Flipped-BRAID parameter of the flipped response surface. See
\code{\link[=evalFlippedBraidModel]{evalFlippedBraidModel()}} for more information on specifying atypical
surfaces}

\item{flip}{String specifying the direction or directions of the surface's
flip.  Must be one of "A", "B", or "both".}

\item{invalidNA}{Specifies what to do with values that are outside the range
of the given BRAID model or doses.  If \code{FALSE} (the default), values "below"
the given range will be set to zero, and values "above" the given range will
be set to Inf.  If \code{TRUE}, all invalid values will be set to \code{NA}.}

\item{lowerBound}{Primarily used by \code{\link[=estimateIAE]{estimateIAE()}}.  If set to TRUE, will
return the lowest non-negative dose that produces an effect no greater than
the specified effect, rather than the highest}
}
\value{
A vector of concentrations the same length as either \code{DA} or \code{DB}
(whichever is not \code{NULL}) and/or \code{effect}, representing the concentration of
the other drug producing the specified effect in combination with the given
dose of the provided drug
}
\description{
Given a particular effect and one of the doses in a flipped combined action
response surface, this function calculates the other dose that will produce
the desired effect.\code{invertFlippedBraidModelA} and
\code{invertFlippedBraidModelB} are convenience wrapper functions that set \code{DA}
or \code{DB} to \code{NULL} to estimate the necessary concentrations of drug A and
drug B respectively.
}
\examples{
fbfit <- fitProtectiveBraid_A(measure ~ concA + concB,
                              protectiveExample, getCIs=FALSE)

invertFlippedBraidModel_A(DB=0, effect=0.5, coef(fbfit), fbfit$flip)
invertFlippedBraidModel_A(DB=0.75, effect=0.5, coef(fbfit), fbfit$flip)
}
