% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{summary.network.result}
\alias{summary.network.result}
\title{Summarize result run by \code{\link{network.run}}}
\usage{
\method{summary}{network.result}(object, ...)
}
\arguments{
\item{object}{Result object created by \code{\link{network.run}} function}

\item{...}{Additional arguments affecting the summary produced}
}
\value{
Returns summary of the network model result
}
\description{
This function uses summary function in coda package to summarize mcmc.list object. Monte carlo error (Time-series SE) is also obtained using the coda package and is printed in the summary as a default.
}
\examples{
network <- with(statins, {
 network.data(Outcomes, Study, Treat, N = N, response = "binomial",
 Treat.order = c("Placebo", "Statin"), covariate = covariate, covariate.type = "discrete")
})
\donttest{
result <- network.run(network)
summary(result)
}
}
