% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{bls_map_state}
\alias{bls_map_state}
\title{choropleth mapping of BLS data}
\usage{
bls_map_state(map_data, fill_rate = NULL, labtitle = NULL,
  lowFill = "green", highFill = "red")
}
\arguments{
\item{map_data}{Dataframe to be used as the map's measures. Usually a result of 
calls to the \code{get_bls_state()} function but other dataframes, 
which include FIPS codes may be used as well.}

\item{fill_rate}{Column name from the dataframe that you want to use as a fill value.}

\item{labtitle}{The main title label for your map passed as a string. The default is no title.}

\item{lowFill}{The fill color of the lower values being mapped. The default color is green, but can be changed to any color accepted by
\code{ggplot2::scale_fill_gradient}.}

\item{highFill}{The fill color of the higher values being mapped. The default color is green, but can be changed to any color accepted by
\code{ggplot2::scale_fill_gradient}.}
}
\description{
Return a ggplot object to render a choropleth map with state outlines.
The map files contain 2015 FIPS codes and can be used with any data set containing
state FIPS codes. They can not be used with the leaflet package but the shape files can be
downloaded from the Census website or with the tigris package. See the "Mapping BLS Data" vignette for this package.
}
\examples{
\dontrun{
# Downlaod employment statistics for April 2016.
df <- get_bls_state("April 2016", seasonality = TRUE)

# Map the unemployment rate from data set.
bls_gg <- bls_map_state(map_data = df, fill_rate = "unemployed_rate", 
             labtitle = "Unemployment Rate")
bls_gg
}



}
\seealso{
\url{https://cran.r-project.org/package=tigris}
}
\keyword{api}
\keyword{bls}
\keyword{economics}
\keyword{geo}
\keyword{geography}
\keyword{map}
\keyword{unemployment}
