% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-blocks.R
\name{manage_blocks}
\alias{manage_blocks}
\alias{manage_blocks_server}
\alias{manage_blocks_ui}
\title{Plugin module for managing board blocks}
\usage{
manage_blocks(server = manage_blocks_server, ui = manage_blocks_ui)

manage_blocks_server(id, board, update, ...)

manage_blocks_ui(id, board)
}
\arguments{
\item{server, ui}{Server/UI for the plugin module}

\item{id}{Namespace ID}

\item{board}{The initial \code{board} object}

\item{update}{Reactive value object to initiate board updates}

\item{...}{Extra arguments passed from parent scope}
}
\value{
A plugin container inheriting from \code{manage_blocks} is returned by
\code{manage_blocks()}, while the UI component (e.g. \code{manage_blocks_ui()}) is
expected to return shiny UI (i.e. \code{\link[shiny:reexports]{shiny::tagList()}}) and the server
component (i.e. \code{manage_blocks_server()}) is expected to return \code{NULL}.
}
\description{
Logic and user experience for adding/removing blocks to the board can be
customized or enhanced by providing an alternate version of this plugin. The
default implementation provides a modal-based UI with simple shiny inputs
such as drop-downs and text fields.
}
\details{
Updates are mediated via the \code{\link[shiny:reactiveVal]{shiny::reactiveVal()}} object passed as
\code{update}, where block updates are communicated as list entry \code{blocks} with
components \code{add} and \code{rm}, where
\itemize{
\item \code{add} may be \code{NULL} or a \code{block} object (block IDs may not already exist),
\item \code{rm} may be \code{NULL} or a string (of existing block IDs).
}
}
