% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{control_hnsw}
\alias{control_hnsw}
\title{Controls for the HNSW algorithm}
\usage{
control_hnsw(M = 25, ef_c = 200, ef_s = 200, grain_size = 1, byrow = TRUE, ...)
}
\arguments{
\item{M}{Controls the number of bi-directional links created for each element during index construction.}

\item{ef_c}{Size of the dynamic list used during construction.}

\item{ef_s}{Size of the dynamic list used during search.}

\item{grain_size}{Minimum amount of work to do (rows in the dataset to add) per thread.}

\item{byrow}{If \code{TRUE} (the default), this indicates that the items in the dataset to be indexed are stored in each row.
Otherwise, the items are stored in the columns of the dataset.}

\item{...}{Additional arguments.}
}
\value{
Returns a list with parameters.
}
\description{
Controls for HNSW algorithm used in the package (see \code{\link[RcppHNSW:hnsw_build]{RcppHNSW::hnsw_build()}} and \code{\link[RcppHNSW:hnsw_search]{RcppHNSW::hnsw_search()}} for details).
}
