% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_order.R
\name{edit_order}
\alias{edit_order}
\title{Edit an order}
\usage{
edit_order(
  orderID = NULL,
  origClOrdID = NULL,
  clOrdID = NULL,
  orderQty = NULL,
  leavesQty = NULL,
  price = NULL,
  stopPx = NULL,
  pegOffsetValue = NULL,
  text = NULL
)
}
\arguments{
\item{orderID}{string. Order ID.}

\item{origClOrdID}{string. The original client order ID}

\item{clOrdID}{string. Optional new client order ID.}

\item{orderQty}{double. Order quantity in units of the instrument (i.e. contracts).}

\item{leavesQty}{string. Optional leaves quantity in units of the instrument (i.e. contracts).
Useful for amending partially filled orders.}

\item{price}{double. Optional limit price for 'Limit', 'StopLimit', and 'LimitIfTouched' orders.}

\item{stopPx}{double. Optional trigger price for 'Stop', 'StopLimit', 'MarketIfTouched', and 'LimitIfTouched' orders.
Use a price below the current price for stop-sell orders and buy-if-touched orders.
Use \code{execInst} of 'MarkPrice' or 'LastPrice' to define the current price used for triggering.}

\item{pegOffsetValue}{string. Optional trailing offset from the current price for 'Stop', 'StopLimit', '
MarketIfTouched', and 'LimitIfTouched' orders; use a negative offset for stop-sell orders and buy-if-touched orders.
Optional offset from the peg price for 'Pegged' orders.}

\item{text}{string. Optional amend annotation. e.g. 'Adjust skew'.}
}
\value{
A \code{data.frame} with information about the amended order. See
\url{https://www.bitmex.com/api/explorer/#!/Order/Order_amend} for more information.
}
\description{
Edit an order that has been placed.
}
\examples{
\dontrun{

# place an order

place_order(symbol = "XBTUSD", price = 5000, orderQty = 100, clOrdID = "myorderid")

# edit the order

edit_order(origClOrID = "myorderid", orderQty = 200)
}

}
