% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp_data.R
\name{simulate_birp_from_results}
\alias{simulate_birp_from_results}
\title{This function simulates a birp_data object using all parameter estimates, dimensionality (methods, locations, timepoints) and the total number of counts nu_ij of a birp object}
\usage{
simulate_birp_from_results(
  x,
  negativeBinomial = FALSE,
  stochastic = FALSE,
  mu = NULL,
  b = NULL,
  logSigma = NULL,
  logPhi = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{An object of type birp}

\item{negativeBinomial}{A boolean indicating if the Poisson (default) or negative binomial model should be used}

\item{stochastic}{A boolean indicating if the deterministic (default) or stochastic trend model should be used}

\item{mu}{A numeric vector denoting the values of mu to be used for the negative binomial model, where the size is given by the number of method-location combinations. If NULL, all mu_i for one method i are set to the (number of locations)^(-1) for that method}

\item{b}{A numeric vector denoting the values of b to be used for the negative binomial model (one per method). If NULL, all b_i are set to 1}

\item{logSigma}{A single value denoting the value of logSigma of the stochastic model to simulate. If NULL, logSigma will be set to -1}

\item{logPhi}{A numeric vector denoting the values of logPhi of the stochastic model to simulate. If NULL, logPhi will be simulated according to the model assumptions}

\item{verbose}{Logical. If \code{FALSE}, the console output is suppressed}
}
\value{
An object of type \link{birp_data}
}
\description{
This function simulates a birp_data object using all parameter estimates, dimensionality (methods, locations, timepoints) and the total number of counts nu_ij of a birp object
}
\examples{
data  <- simulate_birp()
x <- birp(data)
data2 <- simulate_birp_from_results(x)
}
