% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{legacyplot}
\alias{legacyplot}
\title{Plotting univariate Bayesian change point results}
\usage{
legacyplot(x, ...)
}
\arguments{
\item{x}{the result of a call to \code{bcp()}.}

\item{...}{(optional) additional arguments, ignored.}
}
\description{
\code{legacyplot()} produces summary plots of the results of \code{bcp()} when used for univariate analysis; it was the default method prior to package version 3.0.0.
}
\details{
\code{legacyplot()} produces the following plots using \code{base} graphics:

Posterior Means: location in the sequence versus the posterior mean over the iterations. 

Posterior Probability of a Change: location in the sequence versus the relative frequency of iterations which resulted in a change point.
}
\examples{
##### A random sample from a few normal distributions #####
testdata <- c(rnorm(50), rnorm(50, 5, 1), rnorm(50))
bcp.0 <- bcp(testdata, return.mcmc=TRUE)
legacyplot(bcp.0)

}
\seealso{
\code{\link{plot.bcp}}, \code{\link{bcp}}, \code{\link{summary.bcp}}, and \code{\link{print.bcp}} for complete results and summary statistics.
}
\author{
Chandra Erdman and John W. Emerson
}
\keyword{datasets}
