% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmmh_tuning.R
\name{.pilot_run}
\alias{.pilot_run}
\title{Pilot Run for Particle Filter Tuning}
\usage{
.pilot_run(
  y,
  pilot_n,
  pilot_reps,
  init_fn,
  transition_fn,
  log_likelihood_fn,
  obs_times = NULL,
  algorithm = c("SISAR", "SISR", "SIS"),
  resample_fn = c("stratified", "systematic", "multinomial"),
  ...
)
}
\arguments{
\item{y}{A numeric vector or matrix of observations. Each row represents an
observation at a time step.}

\item{pilot_n}{An integer specifying the initial number of particles to use.}

\item{pilot_reps}{An integer specifying the number of repetitions for the
pilot run.}

\item{init_fn}{A function that initializes the particle states. It should
take the current particles as its first argument and return
a vector or matrix of initial particle states.}

\item{transition_fn}{A function describing the state transition model. It
should take the current particles and the current time step as arguments and
return the propagated particles.}

\item{log_likelihood_fn}{A function that computes the log likelihoods for the
particles. It should accept an observation, the current particles, and the
current time step as arguments and return a numeric vector of log likelihood
values.}

\item{obs_times}{A numeric vector indicating the time points at which
observations in \code{y} are available. Must be of the same length as the
number of rows in \code{y}. If not specified, it is assumed that observations
are available at consecutive time steps, i.e., \code{obs_times = 1:nrow(y)}.}

\item{algorithm}{A character string specifying the particle filtering
algorithm to use. Must be one of \code{"SISAR"}, \code{"SISR"}, or
\code{"SIS"}. Defaults to \code{"SISAR"}.}

\item{resample_fn}{A character string specifying the resampling method.
Must be one of \code{"stratified"}, \code{"systematic"}, or
\code{"multinomial"}. Defaults to \code{"stratified"}.}

\item{...}{Additional arguments passed to `init_fn`,
`transition_fn`, and `log_likelihood_fn`.}
}
\value{
A list containing:
\describe{
  \item{variance_estimate}{The estimated variance of the log-likelihoods
  from the pilot run.}
  \item{target_N}{The number of particles used in PMMH algorithm.}
  \item{pilot_loglikes}{A numeric vector of log-likelihood values computed
  during the run.}
}
}
\description{
This internal function repeatedly evaluates the particle filter in order to
estimate the variance of the log-likelihoods and to compute a recommended
target number of particles for the Particle Marginal Metropolis Hastings
(PMMH) algorithm.
}
\details{
The function performs \code{pilot_reps} evaluations of the particle
filter using the provided parameter vector \code{theta}. It then estimates
the variance of the log-likelihoods and scales the initial particle number
by this variance. The final number of particles is taken as the ceiling of
the scaled value with a minimum of 50 and a maximum of 1000.
}
\keyword{internal}
