% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FOIL.R
\name{FOIL}
\alias{FOIL}
\alias{foil}
\title{Use FOIL to learn a rule set for classification}
\usage{
FOIL(
  formula,
  data,
  max_len = 3,
  min_gain = 0.7,
  best_k = 5,
  disc.method = "mdlp"
)
}
\arguments{
\item{formula}{A symbolic description of the model to be fitted. Has to be
of form \code{class ~ .} or \code{class ~ predictor1 + predictor2}.}

\item{data}{A data.frame or \link[arules:transactions-class]{arules::transactions} containing the training data.
Data frames are automatically discretized and converted to transactions with
\code{\link[=prepareTransactions]{prepareTransactions()}}.}

\item{max_len}{maximal length of the LHS of the created rules.}

\item{min_gain}{minimal gain required to expand a rule.}

\item{best_k}{use the average expected accuracy (laplace) of the best k
rules per class for prediction.}

\item{disc.method}{Discretization method used to discretize continuous
variables if data is a data.frame (default: \code{"mdlp"}). See
\code{\link[=discretizeDF.supervised]{discretizeDF.supervised()}} for more supervised discretization methods.}
}
\value{
Returns an object of class \link{CBA} representing the
trained classifier.
}
\description{
Build a classifier rule base using FOIL (First Order Inductive Learner), a
greedy algorithm that learns rules to distinguish positive from negative
examples.
}
\details{
Implements FOIL (Quinlan and Cameron-Jones, 1995) to learn rules and then
use them as a classifier following Xiaoxin and Han (2003).

For each class, we find the positive and negative examples and learn the
rules using FOIL. Then the rules for all classes are combined and sorted by
Laplace accuracy on the training data.

Following Xiaoxin and Han (2003), we classify new examples by
\enumerate{
\item select all the rules whose bodies are satisfied by the example;
\item
from the rules select the best k rules per class (highest expected Laplace
accuracy);
\item average the expected Laplace accuracy per class and choose
the class with the highest average.
}
}
\examples{
data("iris")

# learn a classifier using automatic default discretization
classifier <- FOIL(Species ~ ., data = iris)
classifier

# inspect the rule base
inspect(classifier$rules)

# make predictions for the first few instances of iris
predict(classifier, head(iris))
}
\references{
Quinlan, J.R., Cameron-Jones, R.M. Induction of logic programs:
FOIL and related systems. NGCO 13, 287-312 (1995).
\doi{10.1007/BF03037228}

Yin, Xiaoxin and Jiawei Han. CPAR: Classification based on Predictive
Association Rules, SDM, 2003.
\doi{10.1137/1.9781611972733.40}
}
\seealso{
Other classifiers: 
\code{\link{CBA}()},
\code{\link{CBA_helpers}},
\code{\link{CBA_ruleset}()},
\code{\link{LUCS_KDD_CBA}},
\code{\link{RCAR}()},
\code{\link{RWeka_CBA}}
}
\author{
Michael Hahsler
}
\concept{classifiers}
